/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: OS_Includes.h $
   Last Modification:
    $Author: $
    $Modtime: $
    $Revision: $
   
   Targets:
     WinCE        : yes
 
   Description:
     Headerfile for specific operating system includes
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
     1         20.07.2010  SS       initial version
 
**************************************************************************************/

#ifndef __OS_INCLUDES__H
#define __OS_INCLUDES__H

#pragma warning(disable: 4115 4201 4204 4214 4514)
#include <windows.h>
#include <winnt.h>
#include "stdint.h"
#include <stdio.h>

#pragma warning( disable : 4201)

/* Virtual keys for GetAsyncKeyState() */
#define KEY_Y 0x59
#define KEY_Q 0x51

#ifdef __cplusplus
extern "C"
{
#endif


#include "Ceddk.h"
#include "Ddkreg.h"

void*    OS_Memalloc     (uint32_t ulSize);
void     OS_Memfree      (void* pvMem);
void     OS_Memset       (void* pvMem, uint8_t bFill, uint32_t ulSize);
void     OS_Memcpy       (void* pvDest, void* pvSrc, uint32_t ulSize);
int      OS_Memcmp       (void* pvBuf1, void* pvBuf2, uint32_t ulSize);
void     OS_Memmove      (void* pvDest, void* pvSrc, uint32_t ulSize);

int      OS_Strcmp       (const char* pszBuf1, const char* pszBuf2);
int      OS_Strnicmp     (const char* pszBuf1, const char* pszBuf2, uint32_t ulLen);
int      OS_Strlen       (const char* szText);
char*    OS_Strncpy      (char* szDest, const char* szSource, uint32_t ulLength);

void*    OS_FileOpen     (char* szFile, uint32_t* pulFileLen);
void     OS_FileClose    (void* pvFile);
uint32_t OS_FileRead     (void* pvFile, uint32_t ulOffset, uint32_t ulSize, void* pvBuffer);

void     OS_Sleep        (uint32_t ulSleepTimeMs);

void*    OS_CreateLock   (void);
void     OS_EnterLock    (void* pvLock);
void     OS_LeaveLock    (void* pvLock);
void     OS_DeleteLock   (void* pvLock);

int      OS_KbHit        (void);
int      OS_GetChar      (void);
int      OS_GetLastError (void);

void*    OS_CreateMutex  (void);

void     OS_EnableInterrupts (void* pvOSDependent);
void     OS_DisableInterrupts(void* pvOSDependent);

#ifdef __cplusplus
}
#endif

#endif /* __OS_INCLUDES__H */
